package com.ejie.ab04b.control;

import java.util.HashMap;
import java.util.Map;

import com.ejie.ab04b.model.comun.Elemento;

/**
 * Clase con los valores de los estados
 * 
 * @author Alberto_Diez
 * 
 */
public final class EstadosSolicitudImpl {

	// variable estatica
	private static EstadosSolicitudImpl eventosImplInstance;
	// valores de los eventos
	private Map<String, Elemento> values;

	/**
	 * Constructor privado de la clase.
	 */
	private EstadosSolicitudImpl() {
		this.values = new HashMap<String, Elemento>();

		this.values.put(EstadosSolicitud.ABIERTA.name(), new Elemento(
				"ABIERTA", "Abierta", "Eu_Abierta"));
		this.values.put(EstadosSolicitud.BORRADOR.name(), new Elemento(
				"BORRADOR", "Borrador", "Eu_Borrador"));
		this.values.put(EstadosSolicitud.ENVIADA.name(), new Elemento(
				"ENVIADA", "Enviada", "Eu_Enviada"));
		this.values.put(EstadosSolicitud.SOLICITADA.name(), new Elemento(
				"SOLICITADA", "Solicitada", "Eu_Solicitada"));
		this.values.put(EstadosSolicitud.PROCESADA.name(), new Elemento(
				"PROCESADA", "Procesada", "Eu_Procesada"));
		this.values.put(EstadosSolicitud.BAJA.name(), new Elemento("BAJA",
				"Baja", "Eu_Baja"));

	}

	/**
	 * Obtiene una instancia con los valores de los eventos.
	 * 
	 *  EstadosValues
	 *
	 * @return single instance of EstadosSolicitudImpl
	 */
	public synchronized static EstadosSolicitudImpl getInstance() {

		if (EstadosSolicitudImpl.eventosImplInstance == null) {
			EstadosSolicitudImpl.eventosImplInstance = new EstadosSolicitudImpl();
		}

		return EstadosSolicitudImpl.eventosImplInstance;
	}

	/**
	 * getLista.
	 * 
	 *  name
	 *            String
	 *  ArrayList<Elemento>
	 *
	 * @param name the name
	 * @return the value
	 */
	public Elemento getValue(String name) {
		return this.values.get(name);
	}

}
